unit Helper;

interface

const

	{ 㦥 }
	m_RShift=1;
	m_LShift=2;
	m_Ctrl=4;
	m_Alt=8;
	m_ScrollLock=16;
	m_NumLock=32;
	m_CapsLock=64;
	m_Ins=128;

	{-}
	sc_Q=16;
	sc_W=17;
	sc_E=18;
	sc_A=30;
	sc_S=31;
	sc_D=32;
	sc_R=19;
	sc_F=33;
	sc_H=35;
	sc_T=20;
	sc_Y=21;
	sc_G=34;
	sc_Enter=28;
	sc_ESC=1;

type
	pos = record
		symb:char;
		color:byte;
	end;
	video=array[1..25, 1..80] of pos;

{ 楫᫥ ।}
type pquenue=^quenue_;
	quenue_=record
		next:pquenue;
		prev:pquenue;
		data:integer;
		idx:integer;
	end;
{। ꥪ "᫥ । FIFO"}
type queue = object
	private
		head:pquenue;
		tail:pquenue;
		item:pquenue;
	public
		index:integer;              {࠭ ࠧ ।}
	Constructor Init;           {樠㥬 ꥪ}
	procedure push(d:integer);  {頥 ᫮  ।}
	function pop:integer;       { ᫮  ।}
end;

{ ப ।}
type s_pquenue=^squenue_;
	squenue_=record
		next:s_pquenue;
		prev:s_pquenue;
		data:string;
		idx:integer;
	end;

{। ꥪ "ப । FIFO"}
type squeue = object
	private
		head:s_pquenue;
		tail:s_pquenue;
		item:s_pquenue;
	public
		index:integer;            {࠭ ࠧ ।}
	Constructor Init;         {樠㥬 ꥪ}
	procedure push(d:string); {頥 ப  ।}
	function pop:string;      { ப  ।}
end;

{ꥪ ""}
type screen = object
	private
		x1,x2,y1,y2,xcur,ycur:byte; {न ꥪ}
		xn1,xn2,yn1,yn2:byte;
		buf:^video;   {  ࠭   }
		public
		{ ꥪ ""}
		Constructor init(x,y,w,h,typ,attr:byte);
		{塞 ᨬ  ⥪饩 ப, ᤢ  ᫨  }
		procedure AddChar(ch:char);
		{塞 ப, ७   ᫥ ᫨  墠⠥ }
		procedure AddString(s:string);
		{塞 ப, ७ 㠫   砫  ப
		 ᤢ ᮤন , ᫨  }
		procedure AddLine(s:string);
		{ ᮤন     }
		procedure Scroll;
		{頥 }
		procedure Clear;
		{⠭  }
		procedure SetTitle(s:string);
		{࠭塞   ᮢ뢠 }
		procedure SaveScreen;
		{⠭ ࠭  ࠭}
		procedure RestoreScreen;
		{⮦ ꥪ ""}
		destructor Done;
end;

{ꥪ "騩 ꥪ"}
type fly = object
	x0,y0,dx,dy:integer; {न  饭 न ꥪ}
	col:byte; {ਡ 梥 ꥪ}
	ch:char;  {ᮢ뢠 ᨬ}
	ymax,xmax,ymin,xmin:integer; {}
	{ ꥪ}
	Constructor Init(initx,inity:integer;colo:byte;ymax_,xmax_,ymin_,xmin_:integer);
	Procedure Process; {ந  ୮ ⢨}
	end;

{ᯮ⥫ 㭪樨}
function UpStr(s:string):string; {ਢ ப  孥 ॣ}

{뢮 ⥪⮢ ப 稭  न ,,  ਡ⮬ 梥 col}
procedure WriteLnXY(x,y,col:byte;s:string);

{   筮 ࠬ}
procedure FrameA(x,y,w,h:byte);

{    ࠬ}
procedure FrameB(x,y,w,h:byte);

{ }
procedure HideCursor;

{  }
procedure ShowCursor;

{ ᨢ, ࠦ騩  }
var vmem:video absolute $b800:0000;

{=========================================================================}

implementation
uses Crt;

function UpStr(s:string):string;
var i:byte;
begin
for i:=1 to length(s) do
	s[i]:=UpCase(s[i]);
	UpStr:=s;
end;

destructor Screen.Done;
begin
Dispose(buf);
end;

procedure Screen.SaveScreen;
var tmp:^pos;
    i,j,k,l,s:integer;
    scr:^video;

begin
{GetMem(b,(x2-x1+2)*(y2-y2+2)*7);}
new(buf);
for i:=yn1 to yn2 do
for j:=xn1 to xn2 do begin
{tmp:=ptr(seg(b^),ofs(b^)+((i-yn1)*(yn2-yn1+1)+(j-xn1))*2);}
buf^[i,j]:=vmem[i,j];
{tmp^:=vmem[i,j];}
{write( (i-yn1)*(yn2-yn1+1)+(j-xn1),' ');}
{if readkey=#27 then exit;}
{buf[i][j]:=vmem[i][j];     }
end;
end;

procedure Screen.RestoreScreen;
var tmp:^pos;
    i,j:integer;
begin
for i:=yn1 to yn2 do
for j:=xn1 to xn2 do begin
vmem[i,j]:=buf^[i,j];

end;
end;

procedure Screen.SetTitle(s:string);
var i:byte;
begin
for i:=1 to length(s) do
    vmem[y1-1][(x1)+(x2-x1)div 2 - length(s)div 2+i-2].symb:=s[i];
end;

procedure Screen.Clear;
var i,j:byte;
begin
for i:=y1 to y2 do
for j:=x1 to x2-3 do
vmem[i][j].symb:=' ';
xcur:=x1;
ycur:=y1;
end;

procedure Screen.Scroll;
var tmp:pos;i,j:byte;
begin
for i:=y1+1 to y2 do
    for j:=x1 to x2-2 do
        begin
             tmp:=vmem[i][j];
             vmem[i-1][j]:=tmp;
             end;

for i:=x1 to x2-3 do
vmem[y2][i].symb:=' ';
end;

procedure Screen.AddChar(ch:char);
begin
  vmem[ycur][xcur].symb:=ch;
  if xcur<x2 then inc(xcur);
  if xcur>=x2-2 then
      begin
        xcur:=x1;
        inc(ycur)
      end;
  if ycur>y2 then
      begin
        ycur:=y2;
        Scroll;
      end;
end;

procedure Screen.AddString (s:string);
var i:byte;
begin
  for i:=1 to length(s) do
  AddChar(s[i]);
end;

procedure Screen.AddLine (s:string);
var i:byte;
begin
  for i:=1 to length(s) do
  AddChar(s[i]);
  if ycur<y2 then ycur:=ycur+1
    else
      begin
        ycur:=y2;
        scroll;
      end;
  xcur:=x1;
end;


Constructor Screen.init(x,y,w,h,typ,attr:byte);
var i,j:byte;
const f:array[1..2,1..6]of byte=((218,196,191,179,192,217),(201,205,187,186,200,188));
begin
if typ in [1..2] then else typ:=1;
xn1:=x;
yn1:=y;
xn2:=xn1+w+1;
yn2:=yn1+h-1;

xcur:=x+1;
ycur:=y+1;
y1:=ycur;
x1:=xcur;
x2:=x+1+w;
y2:=y+h-2;
SaveScreen;
vmem[y][x].symb:=char(f[typ][1]);
vmem[y][x].color:=attr;
for i:=1 to w-2 do begin
    vmem[y][x+i].symb:=char(f[typ][2]);
    vmem[y][x+i].color:=attr;
    end;

vmem[y][x+w-1].symb:=char(f[typ][3]);
vmem[y][x+w-1].color:=attr;
for j:=1 to h-2 do
    begin
         vmem[y+j][x].symb:=(char(f[typ][4]));
         vmem[y+j][x].color:=attr;
         for i:=1 to w-2 do begin
            vmem[y+j][x+i].symb:= ' ';
            vmem[y+j][x+i].color:=attr;
            end;

         vmem[y+j][x+w-1].symb:=(char(f[typ][4]));
         vmem[y+j][x+w-1].color:=attr;
    end;
vmem[y+j+1][x].symb:=(char(f[typ][5]));
vmem[y+j+1][x].color:=attr;

for i:=1 to w-2 do begin
    vmem[y+j+1][x+i].symb:=(char(f[typ][2]));
    vmem[y+j+1][x+i].color:=attr;
    end;

vmem[y+j+1][x+w-1].symb:=(char(f[typ][6]));
vmem[y+j+1][x+w-1].color:=attr;
end;

Constructor fly.init(initx,inity:integer;colo:byte;ymax_,xmax_,ymin_,xmin_:integer);
begin
ymax:=ymax_;
xmax:=xmax_;
ymin:=ymin_;
xmin:=xmin_;
repeat
dx:=integer(random(2))-1;
until dx<>0;
repeat
dy:=integer(random(2))-1;
until dy<>0;

x0:=initx;
if x0<1 then x0:=1;
y0:=inity;
if y0<1 then y0:=1;
ch:='*';
col:=colo;
end;

procedure fly.Process;
begin
vmem[y0][x0].symb:=char(0);
vmem[y0][x0].color:=0;
y0:=y0+dy;
if y0<1 then y0:=1;
x0:=x0+dx;
if x0<1 then x0:=1;
vmem[y0][x0].symb:=ch;
vmem[y0][x0].color:=col;
if y0>=ymax then dy:=-1;
if x0>=xmax then dx:=-1;
if y0<=ymin then dy:=1;
if x0<=xmin then dx:=1;
end;

{ }
Constructor queue.Init;
  begin
    new(head);
    new(tail);
    head^.prev:=head;
    head^.next:=tail;
    tail^.prev:=head;
    tail^.next:=tail;
    index:=0;
  end;

{    }
procedure queue.push(d:integer);
  var tmp:pquenue;
  begin
    new(item);         {    }
    item^.data:=d;
    index:=index+1;    {  }
    item^.idx:=index;
    if (head^.next=tail)then
      begin {1 }
        item^.prev:=head;
        item^.next:=tail;
        head^.next:=item;
        tail^.prev:=item;
      end
    else {2  }
      begin
        item^.next:=tail;   {next     }
        tmp:=tail^.prev;  {    }
        tail^.prev:=item;  {    }
        item^.prev:=tmp;   {      }
        tmp^.next:=item;   {   }
      end;
  end;

{    }
function queue.pop:integer;
  var tmp,tmp1:pquenue;
  begin
  if head^.next=tail then
    begin
      pop:=-1;
      exit;
    end;
  tmp:=head^.next;   {  }
  pop:=tmp^.data;
  tmp1:=tmp^.next;   {  }
  head^.next:=tmp1; {     }
  tmp1^.prev:=head;
  dispose(tmp); {  }
  index:=index-1;
  end;


{ string-}
Constructor squeue.Init;
  begin
    new(head);
    new(tail);
    head^.prev:=head;
    head^.next:=tail;
    tail^.prev:=head;
    tail^.next:=tail;
    index:=0;
  end;

{    }
procedure squeue.push(d:string);
  var tmp:s_pquenue;
  begin
    new(item);         {    }
    item^.data:=d;
    index:=index+1;    {  }
    item^.idx:=index;
    if (head^.next=tail)then
      begin {1 }
        item^.prev:=head;
        item^.next:=tail;
        head^.next:=item;
        tail^.prev:=item;
      end
    else {2  }
      begin
        item^.next:=tail;   {next     }
        tmp:=tail^.prev;  {    }
        tail^.prev:=item;  {    }
        item^.prev:=tmp;   {      }
        tmp^.next:=item;   {   }
      end;
  end;

{    }
function squeue.pop:string;
  var tmp,tmp1:s_pquenue;
  begin
  if head^.next=tail then
    begin
      pop:='';
      exit;
    end;
  tmp:=head^.next;   {  }
  pop:=tmp^.data;
  tmp1:=tmp^.next;   {  }
  head^.next:=tmp1; {     }
  tmp1^.prev:=head;
  dispose(tmp); {  }
  index:=index-1;
  end;

procedure WriteLnXY(x,y,col:byte;s:string);
var i:byte;
begin
for i:=0 to Length(s)-1 do
    begin
         vmem[y][x+i].symb:=s[i+1];
         vmem[y][x+i].color:=col;
    end;
end;

procedure FrameA(x,y,w,h:byte);
var i,j:byte;
begin
vmem[y][x].symb:=char(218);
for i:=1 to w-2 do
    vmem[y][x+i].symb:=char(196);
vmem[y][x+w-1].symb:=char(191);
for j:=1 to h-2 do
    begin
         vmem[y+j][x].symb:=char(179);

         for i:=1 to w-2 do
            vmem[y+j][x+i].symb:=' ';

         vmem[y+j][x+w-1].symb:=char(179);
    end;
vmem[y+j+1][x].symb:=(char(192));
for i:=1 to w-2 do
    vmem[y+j+1][x+i].symb:=char(196);

vmem[y+j+1][x+w-1].symb:=char(217);
end;


procedure FrameB(x,y,w,h:byte);
var i,j:byte;
begin
vmem[y][x].symb:=char(201);
for i:=1 to w-2 do
    vmem[y][x+i].symb:=char(205);
vmem[y][x+w-1].symb:=char(187);
for j:=1 to h-2 do
    begin
         vmem[y+j][x].symb:=char(186);

         for i:=1 to w-2 do
            vmem[y+j][x+i].symb:=' ';

         vmem[y+j][x+w-1].symb:=char(186);
    end;
vmem[y+j+1][x].symb:=(char(200));
for i:=1 to w-2 do
    vmem[y+j+1][x+i].symb:=char(205);

vmem[y+j+1][x+w-1].symb:=char(188);
end;


procedure HideCursor;assembler;
  asm
   mov ah,$01
   mov ch,$20
   mov cl, $0
   int $10
  end;
procedure ShowCursor;assembler;
  asm
   mov ah,$01
   mov ch,$6
   mov cl,$7
   int $10
  end;

Function ScanKey:word;assembler;
  asm
    mov ah,01
    int $16
    jz @exit { , }
    {   ,    }
    mov ah,0
    int $16
    @exit:
end;

Function GetKey:word;assembler;
  asm
    mov ah,0
    int $16
  end;

end.

